unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Buttons, ExtDlgs;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    BitBtn1: TBitBtn;
    OpenPictureDialog1: TOpenPictureDialog;
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: Integer; var Resize: Boolean);
  private
    procedure EgergombLenyomasa(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

// A cella kivlasztsnak esemnykezelje
procedure TForm1.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
 // Ha meg nincs gomb a cellban ltrehozzuk azt
 with StringGrid1 do
   if not (Objects[ACol, ARow] is TBitBtn) then
   begin
      Objects[ACol, ARow]:=TBitBtn.Create(StringGrid1);
      with  (Objects [ACol, ARow] As TBitBtn) do
         begin
           // A gomb tulajdonsgainak belltsa
           Parent:=StringGrid1;
           Visible:=True;
           // Mrete a cellamret
           Boundsrect:=CellRect(ACol, ARow);
           // A gomb bitkpe megegyezik a BitBtn1 gombval
           Glyph := TBitmap.Create;
           Glyph:=BitBtn1.Glyph;
           // A egrgomblenyoms esemny kezelse
           OnMouseDown:=EgergombLenyomasa;
         end;
   end;
end;

// A gombok kzs esemnykezelje
procedure TForm1.EgergombLenyomasa(Sender: TObject;
       Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   // A gombon val egrkattints alkalmval
   // a gomb bitkpe frissl a BitBtn1 kpvel
  (Sender as TBitBtn).Glyph:=BitBtn1.Glyph;
end;

// A form lezrsakor felszabadtjuk a lefoglalt erforrsokat
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var i, j: integer;
begin
 with StringGrid1 do
  for i:=0 to ColCount-1 do
   for j:=0 to RowCount-1 do
    if (Objects[i, j] is TBitBtn) then
      begin
        (Objects[i, j] as TBitBtn).Glyph.FreeImage;
        Objects[i, j].Free;
      end;
end;

// A BitBtn1 gomb esemnykezeljben feltltjk az
// j bitkpet
procedure TForm1.BitBtn1Click(Sender: TObject);
begin
 if OpenPictureDialog1.Execute then
  try
    BitBtn1.Glyph.LoadFromFile(OpenPictureDialog1.FileName);
  except
    Beep;
  end;
end;

// Az ablak nem mretezhet t
procedure TForm1.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: Integer; var Resize: Boolean);
begin
  Resize:=false;
end;

end.
